package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestCreateUpload(t *testing.T) {
	Convey("when calling CreateUpload", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		createUploadRequest := testdata.CreateUploadRequest()

		Convey("when CreateUpload succeeds", func() {
			rpcUpload := testdata.RPCUploadVod()
			uploadVod := testdata.UploadVod()
			mocks.backend.On("CreateUpload", ctx, Anything).Return(uploadVod, nil)
			resp, err := server.CreateUpload(ctx, createUploadRequest)
			So(err, ShouldBeNil)
			So(resp, ShouldResemble, &rpc.CreateUploadResponse{Vod: rpcUpload})
		})
		Convey("when CreateUpload fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("CreateUpload", ctx, Anything).Return(nil, errors.New("foo"))
			resp, err := server.CreateUpload(ctx, createUploadRequest)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
