package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// DeleteThumbnails should make a backend call
func (s *Server) DeleteThumbnails(ctx context.Context, r *rpc.DeleteThumbnailsRequest) (*rpc.DeleteThumbnailsResponse, error) {
	err := s.backend.DeleteThumbnails(ctx, &models.DeleteThumbnailsRequest{
		VodID: utils.StrToInt64(r.VodId),
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.DeleteThumbnailsResponse{}, nil
}
