package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestDeleteThumbnails(t *testing.T) {
	Convey("when calling DeleteThumbnails", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		request := &rpc.DeleteThumbnailsRequest{
			VodId: utils.Int64ToStr(testdata.VodID1),
		}

		Convey("when DeleteThumbnails succeeds", func() {
			mocks.backend.On("DeleteThumbnails", ctx, Anything).Return(nil)
			resp, err := server.DeleteThumbnails(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
		})
		Convey("when DeleteThumbnails fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("DeleteThumbnails", ctx, Anything).Return(errors.New("foo"))
			resp, err := server.DeleteThumbnails(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
