package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// FinalizeUpload should make a backend call
func (s *Server) FinalizeUpload(ctx context.Context, r *rpc.FinalizeUploadRequest) (*rpc.FinalizeUploadResponse, error) {
	err := s.backend.FinalizeUpload(ctx, &models.FinalizeUploadRequest{
		VodID: utils.StrToInt64(r.VodId),
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.FinalizeUploadResponse{}, nil
}
