package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestFinalizeUpload(t *testing.T) {
	Convey("when calling FinalizeUpload", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		request := &rpc.FinalizeUploadRequest{
			VodId: utils.Int64ToStr(testdata.VodID1),
		}

		Convey("when FinalizeUpload succeeds", func() {
			mocks.backend.On("FinalizeUpload", ctx, Anything).Return(nil)
			resp, err := server.FinalizeUpload(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
		})
		Convey("when FinalizeUpload fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("FinalizeUpload", ctx, Anything).Return(errors.New("something bad happened"))
			resp, err := server.FinalizeUpload(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
