package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// GetAudibleMagicResponses should make a backend call
func (s *Server) GetAudibleMagicResponses(ctx context.Context, r *rpc.GetAudibleMagicResponsesRequest) (*rpc.AudibleMagicResponsesResponse, error) {
	internalResponse, err := s.backend.GetAudibleMagicResponses(ctx, &models.GetAudibleMagicResponsesRequest{
		VodIDs: utils.StrArrayToInt64Array(r.VodIds),
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return converters.ConvertFromInternalAudibleMagicResponses(internalResponse), nil
}
