package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestGetAudibleMagicResponses(t *testing.T) {
	Convey("when calling GetAudibleMagicResponses", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		request := &rpc.GetAudibleMagicResponsesRequest{
			VodIds: []string{utils.Int64ToStr(testdata.VodID1)},
		}

		Convey("when GetAudibleMagicResponses succeeds", func() {
			mocks.backend.On("GetAudibleMagicResponses", ctx, Anything).Return(testdata.AudibleMagicResponses(), nil)
			resp, err := server.GetAudibleMagicResponses(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
		})
		Convey("when GetAudibleMagicResponses fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("GetAudibleMagicResponses", ctx, Anything).Return(nil, errors.New("foo"))
			resp, err := server.GetAudibleMagicResponses(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
