package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestGetPublicVodAggregationsByIDs(t *testing.T) {
	Convey("when calling GetPublicVodAggregationsByIDs", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		request := &rpc.GetPublicVodAggregationsByIDsRequest{
			VodIds: []string{utils.Int64ToStr(testdata.VodID1)},
		}

		Convey("when GetPublicVodAggregationsByIDs succeeds", func() {
			vodAggregations := testdata.VodAggregations()
			mocks.backend.On("GetPublicVodAggregationsByIDs", ctx, Anything).Return(vodAggregations, nil)
			resp, err := server.GetPublicVodAggregationsByIDs(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
		})
		Convey("when GetPublicVodAggregationsByIDs fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("GetPublicVodAggregationsByIDs", ctx, Anything).Return(nil, errors.New("foo"))
			resp, err := server.GetPublicVodAggregationsByIDs(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
