package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
)

// GetTopVods should make a backend call
func (s *Server) GetTopVods(ctx context.Context, r *rpc.GetTopVodsRequest) (*rpc.GetTopVodsResponse, error) {
	internalResponse, err := s.backend.GetTopVods(ctx, &models.GetTopVodsRequest{
		BroadcastTypes: rpc.ConvertVodTypes(r.BroadcastTypes),
		Language:       r.Language,
		Game:           r.Game,
		Period:         r.Period,
		Sort:           rpc.ConvertVodSort(r.Sort),
		Limit:          r.Limit,
		Offset:         r.Offset,
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.GetTopVodsResponse{Vods: converters.ConvertInternalVods(internalResponse)}, nil
}
