package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// GetVodAppeals should make a backend call
func (s *Server) GetVodAppeals(ctx context.Context, r *rpc.GetVodAppealsRequest) (*rpc.VodAppealsResponse, error) {
	internalResponse, err := s.backend.GetVodAppeals(ctx, &models.GetVodAppealsRequest{
		Priority: utils.FromProtobufBoolValue(r.Priority),
		Resolved: utils.FromProtobufBoolValue(r.Resolved),
		Limit:    r.Limit,
		Offset:   r.Offset,
		VodID:    utils.StrToInt64(r.VodId),
		UserInfo: r.UserInfo,
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return converters.ConvertFromInternalAppealsResponse(internalResponse), nil
}
