package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestGetVodAppeals(t *testing.T) {
	Convey("when calling GetVodAppeals", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		priority := true
		resolved := false
		request := &rpc.GetVodAppealsRequest{
			Priority: utils.ProtobufBoolValue(&priority),
			Resolved: utils.ProtobufBoolValue(&resolved),
			Limit:    100,
			Offset:   0,
			VodId:    utils.Int64ToStr(testdata.VodID1),
			UserInfo: "user_info",
		}

		Convey("when GetVodAppeals succeeds", func() {
			mocks.backend.On("GetVodAppeals", ctx, Anything).Return(testdata.VodAppeals(), nil)
			resp, err := server.GetVodAppeals(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
		})
		Convey("when GetVodAppeals fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("GetVodAppeals", ctx, Anything).Return(nil, errors.New("foo"))
			resp, err := server.GetVodAppeals(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
