package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// GetVodPopularity should make a backend call
func (s *Server) GetVodPopularity(ctx context.Context, r *rpc.GetVodPopularityRequest) (*rpc.VodPopularityResponse, error) {
	internalResponse, err := s.backend.GetVodPopularity(ctx, &models.GetVodPopularityRequest{
		VodID: utils.StrToInt64(r.VodId),
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return converters.ConvertVodPopularity(internalResponse), nil
}
