package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestGetVodPopularity(t *testing.T) {
	Convey("when calling GetVodPopularity", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		request := &rpc.GetVodPopularityRequest{
			VodId: utils.Int64ToStr(testdata.VodID1),
		}

		Convey("when GetVodPopularity succeeds", func() {
			vodPopularity := testdata.VodPopularity()
			mocks.backend.On("GetVodPopularity", ctx, Anything).Return(vodPopularity, nil)
			resp, err := server.GetVodPopularity(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
		})
		Convey("when GetVodPopularity fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("GetVodPopularity", ctx, Anything).Return(nil, errors.New("foo"))
			resp, err := server.GetVodPopularity(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
