package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// GetVodsByIDsIncludeBannedUsers should make a backend call
func (s *Server) GetVodsByIDsIncludeBannedUsers(ctx context.Context, r *rpc.GetVodsByIDsIncludeBannedUsersRequest) (*rpc.GetVodsByIDsIncludeBannedUsersResponse, error) {
	internalResponse, err := s.backend.GetVodsByIDsIncludeBannedUsers(ctx, &models.GetVodsByIDsIncludeBannedUsersRequest{
		VodIDs: utils.StrArrayToInt64Array(r.VodIds),
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.GetVodsByIDsIncludeBannedUsersResponse{Vods: converters.ConvertInternalVods(internalResponse)}, nil
}
