package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// HardDeleteVods should make a backend call
func (s *Server) HardDeleteVods(ctx context.Context, r *rpc.HardDeleteVodsRequest) (*rpc.HardDeleteVodsResponse, error) {
	internalResponse, err := s.backend.HardDeleteVods(ctx, &models.HardDeleteVodsRequest{
		VodIDs: utils.StrArrayToInt64Array(r.VodIds),
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.HardDeleteVodsResponse{Vods: converters.ConvertInternalVods(internalResponse)}, nil
}
