package server

import (
	"fmt"
	"net/http"
	"net/http/httptest"
	"testing"

	. "github.com/smartystreets/goconvey/convey"
)

func TestHealth(t *testing.T) {
	Convey("with a running API", t, func() {
		server, mocks := initTestableServer()

		s := httptest.NewServer(server)
		defer s.Close()

		req, _ := http.NewRequest("GET", fmt.Sprintf("%s/debug/running", s.URL), nil)

		Convey("when its working", func() {
			mocks.backend.On("CheckConnection").Return(nil)
			resp, err := http.DefaultClient.Do(req)
			So(err, ShouldBeNil)
			So(resp.StatusCode, ShouldEqual, http.StatusOK)
		})
		Convey("when its not working", func() {
			mocks.backend.On("CheckConnection").Return(fmt.Errorf("dummyError"))
			resp, err := http.DefaultClient.Do(req)
			So(err, ShouldBeNil)
			So(resp.StatusCode, ShouldEqual, http.StatusServiceUnavailable)
		})
	})
}
