package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// InternalCreateHighlight should make a backend call
func (s *Server) InternalCreateHighlight(ctx context.Context, r *rpc.InternalCreateHighlightRequest) (*rpc.InternalCreateHighlightResponse, error) {
	internalResponse, err := s.backend.InternalCreateHighlight(ctx, &models.InternalCreateHighlightRequest{
		SourceArchiveID: utils.StrToInt64(r.SourceArchiveId),
		OwnerID:         r.OwnerId,
		URI:             r.Uri,
		BroadcastID:     utils.StrToInt64(r.BroadcastId),
		ShowFormats:     converters.ConvertToInternalShowFormats(r.ShowFormats),
		Title:           r.Title,
		Duration:        r.Duration,
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.InternalCreateHighlightResponse{Vod: converters.ConvertInternalVod(internalResponse)}, nil
}
