package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestInternalCreateHighlight(t *testing.T) {
	Convey("when calling InternalCreateHighlight", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		vod := testdata.RPCArchiveVod()
		createHighlightRequest := &rpc.InternalCreateHighlightRequest{
			SourceArchiveId: vod.Id,
			OwnerId:         vod.OwnerId,
			Uri:             vod.Uri,
			BroadcastId:     vod.BroadcastId,
			Title:           "title",
			Duration:        vod.Duration,
		}

		Convey("when InternalCreateHighlight succeeds", func() {
			rpcUpload := testdata.RPCUploadVod()
			uploadVod := testdata.UploadVod()
			mocks.backend.On("InternalCreateHighlight", ctx, Anything).Return(uploadVod, nil)
			resp, err := server.InternalCreateHighlight(ctx, createHighlightRequest)
			So(err, ShouldBeNil)
			So(resp, ShouldResemble, &rpc.InternalCreateHighlightResponse{Vod: rpcUpload})
		})
		Convey("when InternalCreateHighlight fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("InternalCreateHighlight", ctx, Anything).Return(nil, errors.New("foo"))
			resp, err := server.InternalCreateHighlight(ctx, createHighlightRequest)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
