package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// InternalGetVodByID should make a backend call
func (s *Server) InternalGetVodByID(ctx context.Context, r *rpc.InternalGetVodByIDRequest) (*rpc.InternalGetVodByIDResponse, error) {
	internalResponse, err := s.backend.InternalGetVodByID(ctx, &models.InternalGetVodByIDRequest{
		VodID: utils.StrToInt64(r.VodId),
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.InternalGetVodByIDResponse{Vod: converters.ConvertInternalVod(internalResponse)}, nil
}
