package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestInternalGetVodByID(t *testing.T) {
	Convey("when calling InternalGetVodByID", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		request := &rpc.InternalGetVodByIDRequest{
			VodId: utils.Int64ToStr(testdata.VodID1),
		}

		Convey("when InternalGetVodByID succeeds", func() {
			rpcUpload := testdata.RPCUploadVod()
			uploadVod := testdata.UploadVod()
			mocks.backend.On("InternalGetVodByID", ctx, Anything).Return(uploadVod, nil)
			resp, err := server.InternalGetVodByID(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldResemble, &rpc.InternalGetVodByIDResponse{Vod: rpcUpload})
		})
		Convey("when InternalGetVodByID fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("InternalGetVodByID", ctx, Anything).Return(nil, errors.New("foo"))
			resp, err := server.InternalGetVodByID(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
