package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// InternalGetVodMuteInfo should make a backend call
func (s *Server) InternalGetVodMuteInfo(ctx context.Context, r *rpc.InternalGetVodMuteInfoRequest) (*rpc.InternalGetVodMuteInfoResponse, error) {
	internalResponse, err := s.backend.InternalGetVodMuteInfo(ctx, &models.InternalGetVodMuteInfoRequest{
		VodID: utils.StrToInt64(r.VodId),
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.InternalGetVodMuteInfoResponse{MuteInfo: converters.ConvertInternalMuteInfo(internalResponse)}, nil
}
