package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"

	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestInternalGetVodMuteInfo(t *testing.T) {
	Convey("when calling InternalGetVodMuteInfo", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		request := &rpc.InternalGetVodMuteInfoRequest{
			VodId: utils.Int64ToStr(testdata.VodID1),
		}

		Convey("when InternalGetVodMuteInfo succeeds", func() {
			muteInfo := testdata.MuteInfo()
			mocks.backend.On("InternalGetVodMuteInfo", ctx, Anything).Return(muteInfo, nil)
			resp, err := server.InternalGetVodMuteInfo(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
		})
		Convey("when InternalGetVodMuteInfo fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("InternalGetVodMuteInfo", ctx, Anything).Return(nil, errors.New("foo"))
			resp, err := server.InternalGetVodMuteInfo(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
