package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
)

// InternalGetVodsByBroadcastIDs should make a backend call
func (s *Server) InternalGetVodsByBroadcastIDs(ctx context.Context, r *rpc.InternalGetVodsByBroadcastIDsRequest) (*rpc.InternalGetVodsByBroadcastIDsResponse, error) {
	internalResponse, err := s.backend.InternalGetVodsByBroadcastIDs(ctx, &models.InternalGetVodsByBroadcastIDsRequest{
		BroadcastIDs: r.BroadcastIds,
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.InternalGetVodsByBroadcastIDsResponse{Vods: converters.ConvertInternalVods(internalResponse)}, nil
}
