package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// InternalGetVodsByIDs should make a backend call
func (s *Server) InternalGetVodsByIDs(ctx context.Context, r *rpc.InternalGetVodsByIDsRequest) (*rpc.InternalGetVodsByIDsResponse, error) {
	internalResponse, err := s.backend.InternalGetVodsByIDs(ctx, &models.InternalGetVodsByIDsRequest{
		VodIDs: utils.StrArrayToInt64Array(r.VodIds),
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.InternalGetVodsByIDsResponse{Vods: converters.ConvertInternalVods(internalResponse)}, nil
}
