package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// InternalVodRemoveRecords should make a backend call
func (s *Server) InternalVodRemoveRecords(ctx context.Context, r *rpc.InternalVodRemoveRecordsRequest) (*rpc.InternalVodRemoveRecordsResponse, error) {
	internalResponse, err := s.backend.InternalVodRemoveRecords(ctx, &models.InternalVodRemoveRecordsRequest{
		VodIDs: utils.StrArrayToInt64Array(r.VodIds),
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.InternalVodRemoveRecordsResponse{Vods: converters.ConvertInternalVods(internalResponse)}, nil
}
