package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// ManagerCreateCustomThumbnailUploadRequest should make a backend call
func (s *Server) ManagerCreateCustomThumbnailUploadRequest(ctx context.Context, r *rpc.ManagerCreateCustomThumbnailUploadRequestRequest) (*rpc.CreateCustomThumbnailUploadRequestResponse, error) {
	internalResponse, err := s.backend.ManagerCreateCustomThumbnailUploadRequest(ctx, &models.ManagerCreateCustomThumbnailUploadRequestRequest{
		VodID:  utils.StrToInt64(r.VodId),
		CropX:  r.CropX,
		CropY:  r.CropY,
		CropW:  r.CropW,
		CropH:  r.CropH,
		UserID: utils.StrToInt64(r.UserId),
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return converters.ConvertFromInternalThumbnailsResponse(internalResponse), nil
}
