package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestManagerCreateCustomThumbnailUploadRequest(t *testing.T) {
	Convey("when calling ManagerCreateCustomThumbnailUploadRequest", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		request := &rpc.ManagerCreateCustomThumbnailUploadRequestRequest{
			VodId: utils.Int64ToStr(testdata.VodID1),
			CropX: 0,
			CropY: 0,
			CropW: 100,
			CropH: 100,
		}

		Convey("when ManagerCreateCustomThumbnailUploadRequest succeeds", func() {
			createThumbnailUploadResponse := &models.CreateCustomThumbnailUploadRequestResponse{
				URL:      "url",
				UploadID: "uploadID",
			}
			mocks.backend.On("ManagerCreateCustomThumbnailUploadRequest", ctx, Anything).Return(createThumbnailUploadResponse, nil)
			resp, err := server.ManagerCreateCustomThumbnailUploadRequest(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
		})
		Convey("when ManagerCreateCustomThumbnailUploadRequest fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("ManagerCreateCustomThumbnailUploadRequest", ctx, Anything).Return(nil, errors.New("foo"))
			resp, err := server.ManagerCreateCustomThumbnailUploadRequest(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
