package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// ManagerCreateHighlight should make a backend call
func (s *Server) ManagerCreateHighlight(ctx context.Context, r *rpc.ManagerCreateHighlightRequest) (*rpc.ManagerCreateHighlightResponse, error) {
	internalResponse, err := s.backend.ManagerCreateHighlight(ctx, &models.ManagerCreateHighlightRequest{
		VodID:        utils.StrToInt64(r.VodId),
		Description:  r.Description,
		Game:         r.Game,
		Title:        r.Title,
		Language:     r.Language,
		StartSeconds: r.StartSeconds,
		EndSeconds:   r.EndSeconds,
		TagList:      r.TagList,
		CreatedBy:    utils.StrToInt64(r.CreatedBy),
		UserID:       utils.StrToInt64(r.UserId),
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.ManagerCreateHighlightResponse{Vod: converters.ConvertInternalVod(internalResponse)}, nil
}
