package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestManagerCreateHighlight(t *testing.T) {
	Convey("when calling ManagerCreateHighlight", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		createHighlightRequest := testdata.CreateHighlightRequest()

		Convey("when ManagerCreateHighlight succeeds", func() {
			rpcUpload := testdata.RPCUploadVod()
			uploadVod := testdata.UploadVod()
			mocks.backend.On("ManagerCreateHighlight", ctx, Anything).Return(uploadVod, nil)
			resp, err := server.ManagerCreateHighlight(ctx, createHighlightRequest)
			So(err, ShouldBeNil)
			So(resp, ShouldResemble, &rpc.ManagerCreateHighlightResponse{Vod: rpcUpload})
		})
		Convey("when ManagerCreateHighlight fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("ManagerCreateHighlight", ctx, Anything).Return(nil, errors.New("foo"))
			resp, err := server.ManagerCreateHighlight(ctx, createHighlightRequest)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
