package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
)

// ManagerCreateVodAppeals should make a backend call
func (s *Server) ManagerCreateVodAppeals(ctx context.Context, r *rpc.ManagerCreateVodAppealsRequest) (*rpc.CreateVodAppealsResponse, error) {
	err := s.backend.ManagerCreateVodAppeals(ctx, converters.ConvertToInternalCreateAppeals(r))
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.CreateVodAppealsResponse{}, nil
}
