package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/testdata"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestManagerCreateVodAppeals(t *testing.T) {
	Convey("when calling ManagerCreateVodAppeals", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		request := testdata.CreateVodAppealsRequest()

		Convey("when ManagerCreateVodAppeals succeeds", func() {
			mocks.backend.On("ManagerCreateVodAppeals", ctx, Anything).Return(nil)
			resp, err := server.ManagerCreateVodAppeals(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
		})
		Convey("when ManagerCreateVodAppeals fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("ManagerCreateVodAppeals", ctx, Anything).Return(errors.New("foo"))
			resp, err := server.ManagerCreateVodAppeals(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
