package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// ManagerDeleteThumbnails should make a backend call
func (s *Server) ManagerDeleteThumbnails(ctx context.Context, r *rpc.ManagerDeleteThumbnailsRequest) (*rpc.ManagerDeleteThumbnailsResponse, error) {
	err := s.backend.ManagerDeleteThumbnails(ctx, &models.ManagerDeleteThumbnailsRequest{
		VodID:  utils.StrToInt64(r.VodId),
		Path:   r.Path,
		UserID: utils.StrToInt64(r.UserId),
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.ManagerDeleteThumbnailsResponse{}, nil
}
