package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestManagerDeleteThumbnails(t *testing.T) {
	Convey("when calling ManagerDeleteThumbnails", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		request := &rpc.ManagerDeleteThumbnailsRequest{
			VodId:  utils.Int64ToStr(testdata.VodID1),
			Path:   "path",
			UserId: "1234",
		}

		Convey("when ManagerDeleteThumbnails succeeds", func() {
			mocks.backend.On("ManagerDeleteThumbnails", ctx, Anything).Return(nil)
			resp, err := server.ManagerDeleteThumbnails(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
		})
		Convey("when ManagerDeleteThumbnails fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("ManagerDeleteThumbnails", ctx, Anything).Return(errors.New("foo"))
			resp, err := server.ManagerDeleteThumbnails(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
