package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// ManagerGetUserVideoPrivacyProperties should make a backend call
func (s *Server) ManagerGetUserVideoPrivacyProperties(ctx context.Context, r *rpc.ManagerGetUserVideoPrivacyPropertiesRequest) (*rpc.UserVideoPrivacyPropertiesResponse, error) {
	internalResponse, err := s.backend.ManagerGetUserVideoPrivacyProperties(ctx, &models.ManagerGetUserVideoPrivacyPropertiesRequest{
		ChannelID: utils.StrToInt64(r.ChannelId),
		UserID:    utils.StrToInt64(r.UserId),
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return converters.ConvertFromInternalUserVideoPrivacyProperties(internalResponse), nil
}
