package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestManagerGetUserVideoPrivacyProperties(t *testing.T) {
	Convey("when calling ManagerGetUserVideoPrivacyProperties", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		request := &rpc.ManagerGetUserVideoPrivacyPropertiesRequest{
			ChannelId: "1234",
		}

		Convey("when ManagerGetUserVideoPrivacyProperties succeeds", func() {
			mocks.backend.On("ManagerGetUserVideoPrivacyProperties", ctx, Anything).Return(testdata.UserVideoPrivacyProperties(), nil)
			resp, err := server.ManagerGetUserVideoPrivacyProperties(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
		})
		Convey("when ManagerGetUserVideoPrivacyProperties fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("ManagerGetUserVideoPrivacyProperties", ctx, Anything).Return(nil, errors.New("foo"))
			resp, err := server.ManagerGetUserVideoPrivacyProperties(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
