package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestManagerGetUserVodProperties(t *testing.T) {
	Convey("when calling ManagerGetUserVodProperties", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		request := &rpc.ManagerGetUserVodPropertiesRequest{
			ChannelId: "1234",
		}

		Convey("when ManagerGetUserVodProperties succeeds", func() {
			mocks.backend.On("ManagerGetUserVodProperties", ctx, Anything).Return(testdata.UserVodProperties(), nil)
			resp, err := server.ManagerGetUserVodProperties(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
		})
		Convey("when ManagerGetUserVodProperties fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("ManagerGetUserVodProperties", ctx, Anything).Return(nil, errors.New("foo"))
			resp, err := server.ManagerGetUserVodProperties(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
