package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestManagerGetVodByID(t *testing.T) {
	Convey("when calling ManagerGetVodByID", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		request := &rpc.ManagerGetVodByIDRequest{
			VodId: utils.Int64ToStr(testdata.VodID1),
		}

		Convey("when ManagerGetVodByID succeeds", func() {
			rpcUpload := testdata.RPCUploadVod()
			uploadVod := testdata.UploadVod()
			mocks.backend.On("ManagerGetVodByID", ctx, Anything).Return(uploadVod, nil)
			resp, err := server.ManagerGetVodByID(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldResemble, &rpc.ManagerGetVodByIDResponse{Vod: rpcUpload})
		})
		Convey("when ManagerGetVodByID fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("ManagerGetVodByID", ctx, Anything).Return(nil, errors.New("foo"))
			resp, err := server.ManagerGetVodByID(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
