package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// ManagerGetVodMuteInfo should make a backend call
func (s *Server) ManagerGetVodMuteInfo(ctx context.Context, r *rpc.ManagerGetVodMuteInfoRequest) (*rpc.ManagerGetVodMuteInfoResponse, error) {
	internalResponse, err := s.backend.ManagerGetVodMuteInfo(ctx, &models.ManagerGetVodMuteInfoRequest{
		VodID:  utils.StrToInt64(r.VodId),
		UserID: utils.StrToInt64(r.UserId),
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.ManagerGetVodMuteInfoResponse{MuteInfo: converters.ConvertInternalMuteInfo(internalResponse)}, nil
}
