package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"

	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestManagerGetVodMuteInfo(t *testing.T) {
	Convey("when calling ManagerGetVodMuteInfo", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		request := &rpc.ManagerGetVodMuteInfoRequest{
			VodId: utils.Int64ToStr(testdata.VodID1),
		}

		Convey("when ManagerGetVodMuteInfo succeeds", func() {
			muteInfo := testdata.MuteInfo()
			mocks.backend.On("ManagerGetVodMuteInfo", ctx, Anything).Return(muteInfo, nil)
			resp, err := server.ManagerGetVodMuteInfo(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
		})
		Convey("when ManagerGetVodMuteInfo fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("ManagerGetVodMuteInfo", ctx, Anything).Return(nil, errors.New("foo"))
			resp, err := server.ManagerGetVodMuteInfo(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
