package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// ManagerGetVodMuteInfos should make a backend call
func (s *Server) ManagerGetVodMuteInfos(ctx context.Context, r *rpc.ManagerGetVodMuteInfosRequest) (*rpc.ManagerGetVodMuteInfosResponse, error) {
	internalResponse, err := s.backend.ManagerGetVodMuteInfos(ctx, &models.ManagerGetVodMuteInfosRequest{
		VodIDs: utils.StrArrayToInt64Array(r.VodIds),
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.ManagerGetVodMuteInfosResponse{MuteInfos: converters.ConvertInternalMuteInfos(internalResponse)}, nil
}
