package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// ManagerGetVodsByUserIncludeBannedUsers should make a backend call
func (s *Server) ManagerGetVodsByUserIncludeBannedUsers(ctx context.Context, r *rpc.ManagerGetVodsByUserIncludeBannedUsersRequest) (*rpc.ManagerGetVodsByUserIncludeBannedUsersResponse, error) {
	request := &models.ManagerGetVodsByUserIncludeBannedUsersRequest{
		ChannelID:      utils.StrToInt64(r.ChannelId),
		BroadcastTypes: rpc.ConvertVodTypes(r.BroadcastTypes),
		Language:       r.Language,
		Status:         rpc.ConvertVodStatus(r.Status),
		Sort:           rpc.ConvertVodSort(r.Sort),
		Limit:          r.Limit,
		Offset:         r.Offset,
		UserID:         utils.StrToInt64(r.UserId),
	}
	internalResponse, err := s.backend.ManagerGetVodsByUserIncludeBannedUsers(ctx, request)
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.ManagerGetVodsByUserIncludeBannedUsersResponse{Vods: converters.ConvertInternalVods(internalResponse)}, nil
}
