package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// ManagerInternalGetVodByID should make a backend call
func (s *Server) ManagerInternalGetVodByID(ctx context.Context, r *rpc.ManagerInternalGetVodByIDRequest) (*rpc.ManagerInternalGetVodByIDResponse, error) {
	// TODO - [VODI-138]: need to figure out auth
	internalResponse, err := s.backend.ManagerInternalGetVodByID(ctx, &models.ManagerInternalGetVodByIDRequest{
		VodID:  utils.StrToInt64(r.VodId),
		UserID: utils.StrToInt64(r.UserId),
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.ManagerInternalGetVodByIDResponse{Vod: converters.ConvertInternalVod(internalResponse)}, nil
}
