package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// ManagerSearchVods should make a backend call
func (s *Server) ManagerSearchVods(ctx context.Context, r *rpc.ManagerSearchVodsRequest) (*rpc.ManagerSearchVodsResponse, error) {
	internalResponse, err := s.backend.ManagerSearchVods(ctx, &models.ManagerSearchVodsRequest{
		ChannelID: utils.StrToInt64(r.ChannelId),
		Search:    r.Search,
		Limit:     r.Limit,
		Offset:    r.Offset,
		UserID:    utils.StrToInt64(r.UserId),
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.ManagerSearchVodsResponse{Vods: converters.ConvertInternalVods(internalResponse)}, nil
}
