package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestSearchVods(t *testing.T) {
	Convey("when calling ManagerSearchVods", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		request := &rpc.ManagerSearchVodsRequest{
			ChannelId: "1234",
			Search:    "search",
			Limit:     100,
			Offset:    0,
		}

		Convey("when ManagerSearchVods succeeds", func() {
			rpcUpload := testdata.RPCUploadVod()
			uploadVod := testdata.UploadVod()
			vods := []*models.Vod{uploadVod}
			vodsResponse := &models.VodsResponse{
				Vods: vods,
			}
			mocks.backend.On("ManagerSearchVods", ctx, Anything).Return(vodsResponse, nil)
			resp, err := server.ManagerSearchVods(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
			So(len(resp.Vods), ShouldEqual, 1)
			So(resp.Vods[0], ShouldResemble, rpcUpload)
		})
		Convey("when ManagerSearchVods fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("ManagerSearchVods", ctx, Anything).Return(nil, errors.New("foo"))
			resp, err := server.ManagerSearchVods(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
