package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// ManagerSoftDeleteVods should make a backend call
func (s *Server) ManagerSoftDeleteVods(ctx context.Context, r *rpc.ManagerSoftDeleteVodsRequest) (*rpc.ManagerSoftDeleteVodsResponse, error) {
	// TODO - [VODI-138]: need to figure out auth
	internalResponse, err := s.backend.ManagerSoftDeleteVods(ctx, &models.ManagerSoftDeleteVodsRequest{
		VodIDs: utils.StrArrayToInt64Array(r.VodIds),
		UserID: utils.StrToInt64(r.UserId),
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.ManagerSoftDeleteVodsResponse{Vods: converters.ConvertInternalVods(internalResponse)}, nil
}
