package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// ManagerUpdateUserVideoPrivacyProperties should make a backend call
func (s *Server) ManagerUpdateUserVideoPrivacyProperties(ctx context.Context, r *rpc.ManagerUpdateUserVideoPrivacyPropertiesRequest) (*rpc.UserVideoPrivacyPropertiesResponse, error) {
	internalResponse, err := s.backend.ManagerUpdateUserVideoPrivacyProperties(ctx, &models.ManagerUpdateUserVideoPrivacyPropertiesRequest{
		ChannelID:    utils.StrToInt64(r.ChannelId),
		HideArchives: r.HideArchives,
		UserID:       utils.StrToInt64(r.UserId),
	})
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return converters.ConvertFromInternalUserVideoPrivacyProperties(internalResponse), nil
}
