package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestManagerUpdateUserVideoPrivacyProperties(t *testing.T) {
	Convey("when calling ManagerUpdateUserVideoPrivacyProperties", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		request := &rpc.ManagerUpdateUserVideoPrivacyPropertiesRequest{
			ChannelId:    "1234",
			HideArchives: true,
		}

		Convey("when ManagerUpdateUserVideoPrivacyProperties succeeds", func() {
			mocks.backend.On("ManagerUpdateUserVideoPrivacyProperties", ctx, Anything).Return(testdata.UserVideoPrivacyProperties(), nil)
			resp, err := server.ManagerUpdateUserVideoPrivacyProperties(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
		})
		Convey("when ManagerUpdateUserVideoPrivacyProperties fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("ManagerUpdateUserVideoPrivacyProperties", ctx, Anything).Return(nil, errors.New("foo"))
			resp, err := server.ManagerUpdateUserVideoPrivacyProperties(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
