package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// ManagerUpdateUserVodProperties should make a backend call
func (s *Server) ManagerUpdateUserVodProperties(ctx context.Context, r *rpc.ManagerUpdateUserVodPropertiesRequest) (*rpc.UserVodPropertiesResponse, error) {
	request := &models.ManagerUpdateUserVodPropertiesRequest{
		ChannelID:                utils.StrToInt64(r.ChannelId),
		UserID:                   utils.StrToInt64(r.UserId),
		SaveVodsForever:          utils.FromProtobufBoolValue(r.SaveVodsForever),
		VodStorageDays:           utils.FromProtobufInt64Value(r.VodStorageDays),
		CanUploadVod:             utils.FromProtobufBoolValue(r.CanUploadVod),
		YoutubeExportingDisabled: utils.FromProtobufBoolValue(r.YoutubeExportingDisabled),
		SkipUploadModeration:     utils.FromProtobufBoolValue(r.SkipUploadModeration),
		SkipMuting:               utils.FromProtobufBoolValue(r.SkipMuting),
		CanUploadUnlimited:       utils.FromProtobufBoolValue(r.CanUploadUnlimited),
	}
	internalResponse, err := s.backend.ManagerUpdateUserVodProperties(ctx, request)
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return converters.ConvertFromInternalUserVodProperties(internalResponse), nil
}
