package server

import (
	"context"
	"errors"
	"testing"

	"code.justin.tv/vod/vodapi/internal/testdata"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"github.com/golang/protobuf/ptypes/wrappers"
	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"github.com/twitchtv/twirp"
)

func TestManagerUpdateUserVodProperties(t *testing.T) {
	Convey("when calling ManagerUpdateUserVodProperties", t, func() {
		server, mocks := initTestableServer()
		ctx := context.Background()

		newSaveVodsForeverWrapper := wrappers.BoolValue{Value: true}
		request := &rpc.ManagerUpdateUserVodPropertiesRequest{
			ChannelId:       "1234",
			SaveVodsForever: &newSaveVodsForeverWrapper,
		}

		Convey("when ManagerUpdateUserVodProperties succeeds", func() {
			mocks.backend.On("ManagerUpdateUserVodProperties", ctx, Anything).Return(testdata.UserVodProperties(), nil)
			resp, err := server.ManagerUpdateUserVodProperties(ctx, request)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
		})
		Convey("when ManagerUpdateUserVodProperties fails", func() {
			mocks.MockTwirpErrorConvert()
			mocks.backend.On("ManagerUpdateUserVodProperties", ctx, Anything).Return(nil, errors.New("foo"))
			resp, err := server.ManagerUpdateUserVodProperties(ctx, request)
			So(resp, ShouldBeNil)
			So(err, ShouldBeError)
			twirpError := err.(twirp.Error)
			So(twirpError.Code(), ShouldEqual, twirp.Internal)
		})
		mocks.AssertExpectations(t)
	})
}
