package server

import (
	"golang.org/x/net/context"

	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/internal/server/converters"
	rpc "code.justin.tv/vod/vodapi/rpc/vodapi"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// ManagerUpdateVod should make a backend call
func (s *Server) ManagerUpdateVod(ctx context.Context, r *rpc.ManagerUpdateVodRequest) (*rpc.ManagerUpdateVodResponse, error) {
	request := &models.ManagerUpdateVodRequest{
		VodID:         utils.StrToInt64(r.VodId),
		BroadcastID:   utils.StrPtrToInt64Ptr(utils.FromProtobufStringValue(r.BroadcastId)),
		BroadcastType: rpc.ConvertVodType(r.BroadcastType),
		Communities:   r.Communities,
		Description:   utils.FromProtobufStringValue(r.Description),
		Duration:      utils.FromProtobufInt64Value(r.Duration),
		Game:          utils.FromProtobufStringValue(r.Game),
		Language:      utils.FromProtobufStringValue(r.Language),
		Offset:        utils.FromProtobufInt64Value(r.Offset),
		ShowFormats:   converters.ConvertToInternalShowFormats(r.ShowFormats),
		Status:        rpc.ConvertVodStatus(r.Status),
		TagList:       r.TagList,
		ThumbnailPath: utils.FromProtobufStringValue(r.ThumbnailPath),
		Title:         utils.FromProtobufStringValue(r.Title),
		URI:           utils.FromProtobufStringValue(r.Uri),
		Viewable:      rpc.ConvertVodViewable(r.Viewable),
		ViewableAt:    utils.FromProtobufTimestampToTime(r.ViewableAt),
		UserID:        utils.StrToInt64(r.UserId),
	}
	internalResponse, err := s.backend.ManagerUpdateVod(ctx, request)
	if err != nil {
		return nil, converters.ConvertToTwirpError(err, s.errorlogger)
	}
	return &rpc.ManagerUpdateVodResponse{Vod: converters.ConvertInternalVod(internalResponse)}, nil
}
